<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Guru extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('GuruModel');
    }

    public function index()
    {
        $data['title'] = "Data Guru";
        $data['guru'] = 'active';
        $data['data_guru'] = $this->GuruModel->get_data()->result();
        $this->load->view('templates/header', $data);
        $this->load->view('templates/sidebar', $data);
        $this->load->view('guru/index', $data);
        $this->load->view('templates/footer');
    }

    public function _rules()
    {
        $this->form_validation->set_rules('nama', 'Nama Guru', 'required|min_length[3]|max_length[255]', array(
            'required' => '%s Harus Diisi',
            'min_length' => '%s Minimal 3 Karakater Huruf',
            'max_length' => '%s Maksimal 255 Karakter Huruf',
        ));
    }

    public function add_data()
    {
        $this->_rules();

        if ($this->form_validation->run() == false) {
            $this->index();
        } else {
            $data = array(
                'nama' => $this->input->post('nama'),
            );

            $this->GuruModel->add_data($data);
            $this->session->set_flashdata('pesan',
                '<div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Data Berhasil Di Tambahkan</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>'
            );

            redirect('guru');
        }
    }

    public function update_data($id)
    {
        $this->_rules();

        if ($this->form_validation->run() == false) {
            $this->index();
        } else {
            $data = array(
                'id' => $id,
                'nama' => $this->input->post('nama'),
            );
            $this->GuruModel->update_data($data);
            $this->session->set_flashdata('pesan',
                '<div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Data Berhasil Di Ubah</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>'
            );

            redirect('guru');
        }

    }

    public function delete_data($id)
    {
        $data = array(
            'id' => $id,
        );
        $this->GuruModel->delete_data($data);
        $this->session->set_flashdata('pesan',
            '<div class="alert alert-success alert-dismissible fade show" role="alert">
              <strong>Data Berhasil Di Hapus</strong>
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>'
        );

        redirect('guru');
    }

}

/* End of file Guru.php */