<?php

defined('BASEPATH') or exit('No direct script access allowed');
class Siswa extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('SiswaModel');
    }

    public function index()
    {
        $data['title'] = "Daftar Siswa";
        $data['siswa'] = "active";
        $data['data_siswa'] = $this->SiswaModel->get_data('tbl_siswa')->result();
        $this->load->view('templates/header', $data);
        $this->load->view('templates/navbar');
        $this->load->view('templates/sidebar', $data);
        $this->load->view('siswa/index', $data);
        $this->load->view('templates/footer');
    }

    public function tambah()
    {
        $data['title'] = "Tambah Data Siswa";
        $data['tambah'] = "active";

        $this->load->view('templates/header', $data);
        $this->load->view('templates/navbar');
        $this->load->view('templates/sidebar', $data);
        $this->load->view('siswa/tambah', $data);
        $this->load->view('templates/footer');
    }

    public function add_data()
    {
        $this->_rules();

        if ($this->form_validation->run() == false) {
            $this->tambah();
        } else {
            $data = array(
                'nama' => $this->input->post('nama'),
                'kelas' => $this->input->post('kelas'),
                'alamat' => $this->input->post('alamat'),
                'no_telpon' => $this->input->post('no_telpon'),
            );
            $this->SiswaModel->insert_data($data, 'tbl_siswa');

            $this->session->set_flashdata('pesan', '
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Data Berhasil Di Tambahkan</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>'
            );

            redirect('siswa');

        }

    }

    public function _rules()
    {
        $this->form_validation->set_rules('nama', 'Nama Siswa', 'required|min_length[3]|max_length[255]', array(
            'required' => '%s Harus Diisi',
            'min_length' => '%s Tidak Boleh Kurang Dari 3 Huruf',
            'max_length' => '%s Tidak Boleh Lebih Dari 255 Huruf',
        ));

        $this->form_validation->set_rules('kelas', 'Kelas', 'required', array(
            'required' => '%s Harus Diisi',
        ));

        $this->form_validation->set_rules('no_telpon', 'Nomor Telpon', 'required', array(
            'required' => '%s Harus Diisi',
        ));

        $this->form_validation->set_rules('alamat', 'Alamat Siswa', 'required', array(
            'required' => '%s Harus Diisi',
        ));
    }

    public function update_data($id_siswa)
    {
        $this->_rules();

        if ($this->form_validation->run() == false) {
            $this->index();
        } else {
            $data = array(
                'id' => $id_siswa,
                'nama' => $this->input->post('nama'),
                'kelas' => $this->input->post('kelas'),
                'alamat' => $this->input->post('alamat'),
                'no_telpon' => $this->input->post('no_telpon'),
            );
            $this->SiswaModel->update_data($data, 'tbl_siswa');

            $this->session->set_flashdata('pesan', '
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <strong>Data Berhasil Di Diubah</strong>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>'
            );

            redirect('siswa');
        }
    }

    public function delete($id)
    {
        $data = array('id' => $id);
        $this->SiswaModel->delete_data($data, 'tbl_siswa');

        $this->session->set_flashdata('pesan', '
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Data Berhasil Di Dihapus</strong>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>'
        );
        redirect('siswa');
    }

    public function print_data()
    {
        // Mengambil data dari model
        $data['siswa'] = $this->SiswaModel->get_data('tbl_siswa')->result();

        // Memuat view dengan data
        $this->load->view('siswa/print', $data);
    }

    public function export_pdf()
    {
        $this->load->library('dompdf_gen');
        $data['siswa'] = $this->SiswaModel->get_data('tbl_siswa')->result();
        $this->load->view('siswa/pdf', $data);

        $paper_size = 'A4';
        $orientation = 'potrait';
        $html = $this->output->get_output();
        $this->dompdf->set_paper($paper_size, $orientation);

        $this->dompdf->load_html($html);
        $this->dompdf->render();
        $this->dompdf->stream('Data Siswa.pdf', array('Attachment' => 0));
    }
}