<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"><?=$title;?></h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?=base_url('dashboard');?>">Home</a></li>
            <li class="breadcrumb-item active"><?=$title;?></li>
          </ol>
        </div><!-- /.col -->

      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <?=$this->session->flashdata('pesan');?>
          <div class="card">
            <div class="card-header">
              <button class="btn btn-primary btn-sm pr-3" data-toggle="modal" data-target="#modal_add">
                <i class="fas fa-plus"></i>
                Tambah Data
              </button>
              <a href="<?=base_url('siswa/print_data');?>" class="btn btn-info btn-sm pr-3"><i class="fas fa-print"></i>
                Print Data
              </a>
              <a href="<?=base_url('siswa/export_pdf');?>" class="btn btn-success btn-sm pr-3"><i
                  class="fas fa-pdf"></i>
                Export PDF
              </a>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example2" class="table table-bordered table-hover">
                <thead>
                  <tr class="text-center">
                    <th>No </th>
                    <th>Nama Guru </th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>

                  <?php if (isset($data_guru) && $data_guru != null): ?>
                  <?php $no = 1;?>
                  <?php foreach ($data_guru as $key => $value): ?>
                  <tr class="text-center">
                    <td><?=$no;?></td>
                    <td>
                      <?=$value->nama;?>
                    </td>
                    <td>
                      <button type="button" class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#modal_edit_<?=$value->id;?>">
                        <i class="fas fa-edit"></i>
                      </button>
                      <a href="<?=base_url('guru/delete_data/' . $value->id);?>"
                        onclick="return confirm('Apakah anda yakin untuk menghapus data guru ini?')"
                        class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>
                    </td>
                  </tr>
                  <?php $no += 1;?>
                  <?php endforeach?>
                  <?php endif?>

                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->

        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </section>
  <!-- /.content -->

  <!-- modal -->
  <!-- Modal add-->
  <div class="modal fade" id="modal_add" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Add Data Guru</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?=base_url('guru/add_data');?>" method="post">
          <div class="modal-body">
            <div class="form-group">
              <label for="nama">Nama Guru</label>
              <input type="text" name="nama" class="form-control" id="nama">
              <?=form_error('nama', '<div class="text-small text-danger">', '</div>');?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Add Data</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <!-- Akhir modal add-->

  <!-- Modal edit-->
  <?php foreach ($data_guru as $value): ?>
  <div class="modal fade" id="modal_edit_<?=$value->id;?>" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Edit Data Guru</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?=base_url('guru/update_data/' . $value->id);?>" method="post">
          <div class="modal-body">
            <div class="form-group">
              <label for="nama">Nama Guru</label>
              <input type="text" name="nama" value="<?=$value->nama;?>" class="form-control" id="nama">
              <?=form_error('nama', '<div class="text-small text-danger">', '</div>');?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Update Data</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <?php endforeach?>
  <!-- Akhir modal edit-->
</div>
<!-- /.content-wrapper -->