<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"><?=$title;?></h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?=base_url('dashboard');?>">Home</a></li>
            <li class="breadcrumb-item active"><?=$title;?></li>
          </ol>
        </div><!-- /.col -->

      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <?=$this->session->flashdata('pesan');?>
          <div class="card">
            <div class="card-header">
              <a href="<?=base_url('siswa/tambah');?>" class="btn btn-primary btn-sm pr-3"><i class="fas fa-plus"></i>
                Tambah Data
              </a>
              <a href="<?=base_url('siswa/print_data');?>" class="btn btn-info btn-sm pr-3"><i class="fas fa-print"></i>
                Print Data
              </a>
              <a href="<?=base_url('siswa/export_pdf');?>" class="btn btn-success btn-sm pr-3"><i
                  class="fas fa-pdf"></i>
                Export PDF
              </a>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example2" class="table table-bordered table-hover">
                <thead>
                  <tr class="text-center">
                    <th>No </th>
                    <th>Nama Siswa </th>
                    <th>Kelas</th>
                    <th>Alamat</th>
                    <th>No Telpon</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $no = 1;?>
                  <?php foreach ($data_siswa as $value): ?>
                  <tr class="text-center">
                    <td><?=$no;?></td>
                    <td>
                      <?=$value->nama;?>
                    </td>
                    <td>
                      <?=$value->kelas;?>
                    </td>
                    <td>
                      <?=$value->alamat;?>
                    </td>
                    <td>
                      <?=$value->no_telpon;?>
                    </td>
                    <td>
                      <button type="button" class="btn btn-warning btn-sm" data-toggle="modal"
                        data-target="#modal_edit_<?=$value->id;?>">
                        <i class="fas fa-edit"></i>
                      </button>
                      <a href="<?=base_url('siswa/delete/' . $value->id);?>"
                        onclick="return confirm('Apakah anda yakin untuk menghapus data siswa ini?')"
                        class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>
                    </td>
                  </tr>
                  <?php $no += 1;?>
                  <?php endforeach?>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->

        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </section>
  <!-- /.content -->

  <!-- modal -->
  <!-- Modal -->
  <?php foreach ($data_siswa as $value): ?>
  <div class="modal fade" id="modal_edit_<?=$value->id;?>" tabindex="-1" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Edit Data Siswa</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?=base_url('siswa/update_data/' . $value->id);?>" method="post">
          <div class="modal-body">
            <div class="form-group">
              <label for="nama">Nama Siswa</label>
              <input type="text" name="nama" value="<?=$value->nama;?>" class="form-control" id="nama">
              <?=form_error('nama', '<div class="text-small text-danger">', '</div>');?>
            </div>
            <div class="form-group">
              <label for="kelas">Kelas</label>
              <input type="text" name="kelas" value="<?=$value->kelas;?>" class="form-control" id="kelas">
              <?=form_error('kelas', '<div class="text-small text-danger">', '</div>');?>
            </div>
            <div class="form-group">
              <label for="no_telpon">No. Telpon</label>
              <input type="text" name="no_telpon" value="<?=$value->no_telpon;?>" class="form-control" id="no_telpon">
              <?=form_error('no_telpon', '<div class="text-small text-danger">', '</div>');?>
            </div>
            <div class="form-group">
              <label for="alamat">Alamat</label>
              <textarea class="form-control" name="alamat" rows="3" id="alamat" placeholder="">
                <?=$value->alamat;?>
              </textarea>
              <?=form_error('alamat', '<div class="text-small text-danger">', '</div>');?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Update Data</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <?php endforeach?>
  <!-- Akhir modal -->
</div>
<!-- /.content-wrapper -->